/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebottom;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.vfx.RainingGoldEffect;
import com.megacrit.cardcrawl.vfx.combat.FlashAtkImgEffect;

public class GoopPuddle2
extends AbstractImageEvent {
    public static final String ID = "World of Goop";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("World of Goop");
    public static final String NAME = GoopPuddle2.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = GoopPuddle2.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = GoopPuddle2.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String GOLD_DIALOG = DESCRIPTIONS[1];
    private static final String LEAVE_DIALOG = DESCRIPTIONS[2];
    private CurScreen screen = CurScreen.INTRO;
    private int damage = 11;
    private int gold = 75;
    private int goldLoss = MathUtils.random(20, 50);

    public GoopPuddle2() {
        super(NAME, DIALOG_1, "images/events/goopPuddle.jpg");
        if (this.goldLoss > AbstractDungeon.player.gold) {
            this.goldLoss = AbstractDungeon.player.gold;
        }
        GenericEventDialog.setDialogOption(OPTIONS[0] + this.gold + OPTIONS[1] + this.damage + OPTIONS[2]);
        GenericEventDialog.setDialogOption(OPTIONS[3] + this.goldLoss + OPTIONS[4]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                switch (buttonPressed) {
                    case 0: {
                        GenericEventDialog.updateBodyText(GOLD_DIALOG);
                        GenericEventDialog.clearAllDialogs();
                        AbstractDungeon.player.damage(new DamageInfo(AbstractDungeon.player, this.damage));
                        AbstractDungeon.effectList.add(new FlashAtkImgEffect(AbstractDungeon.player.hb.cX, AbstractDungeon.player.hb.cY, AbstractGameAction.AttackEffect.FIRE));
                        AbstractDungeon.effectList.add(new RainingGoldEffect(this.gold));
                        AbstractDungeon.player.gainGold(this.gold);
                        GenericEventDialog.setDialogOption(OPTIONS[5]);
                        this.screen = CurScreen.RESULT;
                        this.logMetric("Gather Gold");
                        break;
                    }
                    case 1: {
                        GenericEventDialog.updateBodyText(LEAVE_DIALOG);
                        AbstractDungeon.player.loseGold(this.goldLoss);
                        GenericEventDialog.clearAllDialogs();
                        GenericEventDialog.setDialogOption(OPTIONS[5]);
                        this.screen = CurScreen.RESULT;
                        this.logMetric("Left");
                    }
                }
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum CurScreen {
        INTRO,
        RESULT;

    }
}

